
function [icaS,icaA,pcaU,pcaS,pcaV] = ICAdim(X,Jvalues);

% if Jvalues is a single negative value, just run ICA once for this value.

CorrThresh=0.9;
RepeatsPerJ=10; % 10
g='tanh'; %g='pow3';
epsilon=1e-13;
DoPass2=1;

if length(Jvalues==1) & Jvalues<0
  J=-Jvalues;
  [pcaU,pcaS,pcaV]=nets_svds(X,J);
  [icaS,icaA,~]=fastica(pcaV','approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
  return  % I'm so so so sorry
end

%%% first-pass: compare a range of dimensionalities
[pcaU,pcaS,pcaV]=nets_svds(X,max(Jvalues));
NStrongCorrs=[];
for J=Jvalues
  grot2=[];
  for JJ=1:RepeatsPerJ
    grot=randn(size(X,1),1)>0;  [pcaU1,pcaS1,pcaV1]=nets_svds(X(grot==0,:),J);  [pcaU2,pcaS2,pcaV2]=nets_svds(X(grot==1,:),J);
    [icaS,icaA,~]   = fastica(pcaV(:,1:J)', 'approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
    [icaS1,icaA1,~] = fastica(pcaV1',       'approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
    [icaS2,icaA2,~] = fastica(pcaV2',       'approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
    [grotA,grotB,grotC,grotD,grotE,grotF] = ssorder2(icaS',icaA',icaS1',icaA1',icaS2',icaA2');
    icaS=grotA';icaA=grotB';icaS1=grotC';icaA1=grotD';icaS2=grotE';icaA2=grotF';
    grot=corr([icaS' icaS1' icaS2']);  % figure; imagesc(grot,[-1 1]); figure;plot(diag(grot(J+1:2*J,2*J+1:end))');
    grot2=[grot2;diag(grot(J+1:2*J,2*J+1:end))'];
  end;
  figure; plot(grot2'+randn(size(grot2'))*0.001); hold on; plot(mean(grot2)','k','LineWidth',2); title(sprintf('J=%d',J)); drawnow;
  NStrongCorrs=[NStrongCorrs sum(mean(grot2)>CorrThresh)];
end;
figure; plot(Jvalues,NStrongCorrs); drawnow; NStrongCorrs

if DoPass2
  %%% second-pass: find best ICA run for chosen dimensionality
  grot=find(NStrongCorrs==max(NStrongCorrs)); grot=grot(1)
  J=Jvalues(grot);         % dimensionality input to ICA
  JJJ=NStrongCorrs(grot);  % how many we aim to keep
  grot2=[]; grot3=-1;
  for JJ=1:RepeatsPerJ*3
      grot=randn(size(X,1),1)>0;  [pcaU1,pcaS1,pcaV1]=nets_svds(X(grot==0,:),J);  [pcaU2,pcaS2,pcaV2]=nets_svds(X(grot==1,:),J);
      [icaS,icaA,~]   = fastica(pcaV(:,1:J)', 'approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
      [icaS1,icaA1,~] = fastica(pcaV1',       'approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
      [icaS2,icaA2,~] = fastica(pcaV2',       'approach','symm','g',g,'epsilon',epsilon,'maxNumIterations',3000,'lastEig',J);
      [grotA,grotB,grotC,grotD,grotE,grotF] = ssorder2(icaS',icaA',icaS1',icaA1',icaS2',icaA2');
      icaS=grotA';icaA=grotB';icaS1=grotC';icaA1=grotD';icaS2=grotE';icaA2=grotF';
      grot=corr([icaS' icaS1' icaS2']);  % figure; imagesc(grot,[-1 1]); figure;plot(diag(grot(J+1:2*J,2*J+1:end))');
      grot2=[grot2 mean(diag(grot(J+1:J+JJJ,2*J+1:2*J+JJJ)))]
      if grot2(end)>grot3
        grot3=grot2(end);  icaAout=icaA(:,1:JJJ);  icaSout=icaS(1:JJJ,:);      
      end
  end;
  icaA=icaAout; icaS=icaSout;
end;

