
function [YP] = PredDeltaCV(X,Y,J,CONF);

YP=0*Y/0;
Ncv=10;                    % number of cross-validation folds
I=randi(Ncv,length(Y),1);  % create random cross-validation folds

for i=1:Ncv
  OUT=(I==i);  IN=(I~=i);
  if Ncv==1  % no cross-validation
    IN=OUT;
  end

  x=X(IN,:);  y=Y(IN);  ym=mean(y);  y=y-ym;
  if size(CONF,1)>0,  CONFbeta=pinv(CONF(IN,:))*x; x=x-CONF(IN,:)*CONFbeta;  end;
  if J>0,  [x,pcaS,pcaV]=nets_svds(x,J);  end;
  beta1=pinv(x)*y;

  x=X(OUT,:);
  if size(CONF,1)>0,  x=x-CONF(OUT,:)*CONFbeta;  end;
  if J>0, x=x*pcaV*inv(pcaS);  end;
  YP(OUT)=x*beta1+ym;
end

